#include "BMZ00050.h"
BMZ00050 nfc(8,13,12,11,10,REG_MODE);      //SPI軟件
/*
//BMZ00050 nfc(REG_MODE);           //uart硬件
//BMZ00050 nfc(8,10,REG_MODE);              //SPI硬件
//BMZ00050 nfc(8,13,12,11,10,REG_MODE);     //SPI軟件
//BMZ00050 nfc(8,REG_MODE);                 //IIC硬件
//BMZ00050 nfc(8,A5,A4,REG_MODE);   //IIC軟件
//BMZ00050 nfc(REG_MODE);           //uart
*/

uint8_t SRAM_WRITE_40[4]={0x40,0x40,0x40,0x40};                       //SRAM_WRITE_40存儲要寫入Page0x40的數據

uint8_t SRAM_WRITE_41[8]={0x41,0x41,0x41,0x41,0x42,0x42,0x42,0x42};   //SRAM_WRITE_41存儲要寫入Page0x41-0x42的數據
uint8_t SRAM_READ[12]={0};                                            //SRAM_READ[12]存儲讀取的Page0x40-0x42數據
uint8_t writedata_count=1;                                            //寫入次數
uint8_t readdata_count=1;                                             //讀取次數

void setup()
{
    Serial.begin(9600);         //初始化串口，以便serial monitor使用
    nfc.begin();                //初始化模塊
        
    nfc.writePage(0x40,SRAM_WRITE_40,SRAM_MEMORY);    //往SRAM第0x40頁寫入單個page數據：0x40,0x40, 0x40,0x40；
    nfc.writePages(0x41,SRAM_WRITE_41,2,SRAM_MEMORY); //往SRAM第0x41頁為首頁，連續寫入2pages數據：0x41,0x41,0x41,0x41,0x42,0x42,0x42,0x42；

    nfc.readPages(0x40,SRAM_READ,3,SRAM_MEMORY);      //讀取SRAM第0x40頁為首頁的3頁數據，存放於數組SRAM_READ[12]


}

void loop() 
{
    if(writedata_count == 1)
    {
       nfc.writePage(0x40,SRAM_WRITE_40,SRAM_MEMORY);    //往SRAM第0x40頁寫入單個page數據：0x40,0x40, 0x40,0x40；
       nfc.writePages(0x41,SRAM_WRITE_41,2,SRAM_MEMORY); //往SRAM第0x41頁為首頁，連續寫入2pages數據：0x41,0x41,0x41,0x41,0x42,0x42,0x42,0x42；

       writedata_count = 0;
    }
    if(writedata_count == 1)
    {
       nfc.readPages(0x40,SRAM_READ,3,SRAM_MEMORY);      //讀取SRAM第0x40頁為首頁的3頁數據，存放於數組SRAM_READ[12]

       readdata_count = 0;
    }

    Serial.print("ReadPage40 data: ");  //顯示40頁數據
    nfc.PrintHexChar(SRAM_READ,1,4);

    Serial.print("ReadPage41 data: ");  //顯示41頁數據
    nfc.PrintHexChar(SRAM_READ,5,8);

    Serial.print("ReadPage42 data: ");  //顯示42頁數據
    nfc.PrintHexChar(SRAM_READ,9,12);

    Serial.println(" ");
    delay(1000);

}
