

/*************************************************
File:               BMZ00050.h
Author:             Tree
Description:        對倍創NFC模塊BMZ00050應用庫，進行類、函數定義
History：            版本修改描述
  V1.00   -- initial version；2021-04-01；Arduino IDE :  ≥v1.8.13
**************************************************/
#ifndef __BMZ00050_H__
#define __BMZ00050_H__

#include "Arduino.h"
#include "BM_SPI_MASTER.h"
#include "BM_IIC.h"

#define SPI_DATA_WRITE      (0x01)
#define SPI_DATA_READ       (0x03)

#define REG_MODE              (1)
#define TRANSPARENT_MODE      (0)

#define SRAM_MEMORY      (0x01)
#define EEPROM_MEMORY    (0x02)

#define SLEEP_MODE       (0x01)
#define DEEPSLEEP_MODE   (0x02)
#define NORMAL_MODE      (0x03)
#define WDT_8MS          (0x00)
#define WDT_32MS         (0x04)
#define WDT_128MS        (0x08)
#define WDT_512MS        (0x0c)
#define WDT_1024MS       (0x10)
#define WDT_2048MS       (0x14)
#define WDT_4096MS       (0x18)
#define WDT_8192MS       (0x1c)

#define LVD_ENABLE      (0x10)
#define LVD_DISABLE     (0x00)
#define LVD_1V8         (0x00)
#define LVD_2V          (0x01)
#define LVD_2V4         (0x02)
#define LVD_2V7         (0x03)
#define LVD_3V          (0x04)
#define LVD_3V3         (0x05)
#define LVD_3V6         (0x06)
#define LVD_4V          (0x07)

#define BAUD_1200       (0x00)
#define BAUD_2400       (0x01)
#define BAUD_4800       (0x02)
#define BAUD_9600       (0x03)

#define IRQ_ACTIVEHIGH        (0x00)
#define IRQ_ACTIVELOW         (0x01)

#define SPI_TIMEOUT    (20)
#define IIC_TIMEOUT    (20)
#define UART_TIMEOUT   (500)

#define EER_INVALID_ACK             (-1)
#define EER_TIMEOUT                 (-2)
#define EER_INVALID_FRAME           (-3)
#define EER_INSUFFICIENT_BUFFER     (-5)

class BMZ00050
{
public:
/***************   初始化      ****************/
    BMZ00050(uint8_t workmode);                                        //硬件UART
    BMZ00050(uint8_t irq,uint8_t scs, uint8_t workmode);               //硬件SPI
    BMZ00050(uint8_t irq,uint8_t clk, uint8_t miso, uint8_t mosi, uint8_t scs, uint8_t workmode);  //軟件SPI
    BMZ00050(uint8_t irq, uint8_t workmode);                           //硬件IIC
    BMZ00050(uint8_t irq,uint8_t scl, uint8_t sda, uint8_t workmode);  //軟件IIC
    void begin(void);
    void setWorkMode(uint8_t workmode);

/***************   通用函數      ****************/
    int8_t sendCommandCheckAck(uint8_t *cmdbuff, uint8_t cmdlen, uint16_t timeout);
    int8_t getFWVer(uint16_t &savever);
    int8_t getPID(uint16_t &savepid);
    int8_t getVID(uint16_t &savevid);
    int8_t getSN(uint8_t *buff);
    int8_t getNFCProtocol(uint8_t *buff);
    int8_t getStatusRegister(uint8_t &savestatus);

    int8_t setLVD(uint8_t lvden, uint8_t lvdvolage);
    int8_t getLVD(uint8_t &savelvd);
    int8_t setBaudRate(uint8_t baudrate);
    int8_t getBaudRate(uint8_t &savebaud);
    int8_t setIRQactiveMode(uint8_t irqactivemode);
    int8_t resetModule(void);
    int8_t setOperationMode(uint8_t sleepmode, uint8_t wdttime=WDT_8192MS);
    int8_t getOperationMode(uint8_t &savehm);

    int8_t readNFCWRA(uint8_t &savelastpageaddr);
/***************   讀寫函數      ****************/
    int8_t writePage(uint8_t pageaddr,uint8_t *databuff,uint8_t memory=SRAM_MEMORY);
    int8_t writePages(uint8_t pageaddr,uint8_t *databuff, uint8_t pagelen,uint8_t memory=SRAM_MEMORY);
    int8_t readPages(uint8_t pageaddr,uint8_t *databuff,uint8_t pagelen,uint8_t memory=SRAM_MEMORY);

    void writeDataPacket(uint8_t *databuff,uint8_t datalen);
    int8_t readDataPacket(uint8_t *databuff);
/***************   其它      ****************/


    void PrintHex(uint8_t *data, uint8_t num_first, uint8_t num_last);
    void PrintHexChar(uint8_t *data, uint8_t num_first, uint8_t num_last);
    
private:
    BM_SPI_MASTER *spi_dev = NULL;
    BM_IIC *iic_dev = NULL;
    uint8_t _flag=0;        //檢測位
    uint8_t _irq;           //INT線
    uint8_t _ss;            //scs線
    uint8_t _nfcmode=0;     //工作模式：寄存器/透傳
    uint8_t _baudflag=1;     //記載當前波特率
    
    uint16_t  _startime=0;  //uart接收數據時間
    uint16_t  _latertime=0;
    uint8_t _headerflag=0;
    
    uint16_t  spi_timeout = SPI_TIMEOUT;
    uint16_t  iic_timeout = IIC_TIMEOUT;
    uint16_t  uart_timeout = UART_TIMEOUT;
    
    const uint8_t BMZ00050_keep_ack[6]={0x00,0x00,0xff,0x00,0xff,0x00};
    uint8_t BMZ00050_keep_ackpacket[7]={0};
    uint8_t BMZ00050_keep_cmdpacket[250]={0};

    
    int8_t sendCommand(uint8_t *cmdbuff, uint8_t cmdlen, uint8_t *keepbuff, uint8_t keeplen);



};





#endif
