#ifndef _BM_SPI_H_
#define _BM_SPI_H_
#include "Arduino.h"
#include "SPI.h"


class BM_SW_SPI
{
  public:

    void begin(void);

    uint8_t transfer(uint8_t data);
    uint16_t transfer16(uint16_t data);
    void transfer(uint8_t *buf, uint8_t count);

    void setBitOrder(uint8_t data_mode);
    void setClockDivider(uint8_t transfer_clock);
    void setDataMode(uint8_t transfer_mode);

    void changeSPIPin(uint8_t sck, uint8_t mosi, uint8_t miso);
    void end();
    unsigned char e = 0x33;
  private:
    void delay();
    uint8_t transferMode0(uint8_t data);
    uint8_t transferMode1(uint8_t data);
    uint8_t transferMode2(uint8_t data);
    uint8_t transferMode3(uint8_t data);

    uint8_t _begin;
    uint8_t _end;
    uint8_t _spiTransferMode;
    uint8_t _spiDataMode;
    uint8_t _spiTransferClock;
    uint8_t _timer;

    uint8_t _spiSck;
    uint8_t _spiMosi;
    uint8_t _spiMiso;
};
/*
  Adafruit_SPIDevice(int8_t cspin, uint32_t freq = 1000000,
                     BitOrder dataOrder = SPI_BITORDER_MSBFIRST,
                     uint8_t dataMode = SPI_MODE0, SPIClass *theSPI = &SPI);

  Adafruit_SPIDevice(int8_t cspin, int8_t sck, int8_t miso, int8_t mosi,
                     uint32_t freq = 1000000,
                     BitOrder dataOrder = SPI_BITORDER_MSBFIRST,
                     uint8_t dataMode = SPI_MODE0);*/
class BM_SPI_MASTER
{
  public:
    BM_SPI_MASTER();
    BM_SPI_MASTER(uint8_t cspin, uint32_t clock = SPI_CLOCK_DIV2, uint8_t bitOrder = MSBFIRST, uint8_t dataMode  = SPI_MODE0, SPIClass *theSPI = &SPI);
    BM_SPI_MASTER(uint8_t cspin, uint8_t sckpin, uint8_t misopin, uint8_t mosipin, uint8_t clock , uint8_t bitOrder , uint8_t dataMode);

    void begin(void);

    void beginTransaction(void);
    void beginTransaction(SPISettings settings);
    void beginTransaction(uint32_t clock,uint8_t bitOrder,uint8_t dataMode);
    void endTransaction();

    void attachInterrupt(void);
    void detachInterrupt(void);
    void usingInterrupt(uint8_t interruptNumber);
    void notUsingInterrupt(uint8_t interruptNumber);



    uint8_t transfer(uint8_t data);
    uint16_t transfer16(uint16_t data);
    void transfer(uint8_t *buf, uint8_t count);

    void writeByte(uint8_t data);
    void writeBytes(uint8_t* buffer, uint8_t len);
    
    void readBytes(uint8_t* buffer, uint8_t len,uint8_t sendvalue = 0xff);
    uint8_t readByte(uint8_t sendvalue = 0xff);


    void setBitOrder(uint8_t data_mode);
    void setClockDivider(uint8_t transfer_clock);
    void setDataMode(uint8_t transfer_mode);
    void end();

    uint8_t _spiSck;
    uint8_t _spiMosi;
    uint8_t _spiMiso;
    uint8_t _spiCs;
  private:
    BM_SW_SPI*   _the_BM_SPI = NULL;
    SPIClass* _the_SPIClass = NULL;
    BM_SW_SPI _BM_SW_SPI;
    uint8_t _spiTransferMode;
    uint8_t _spiDataMode;
    uint32_t _spiTransferClock;

    uint8_t _begin = 0;
};


#endif
