/*****************************************************************
File:        BMduino_WS2812.cpp
Author:      BEST MODULES CORP.
Description: BMduino_WS2812.cpp is the library for WS2812 drive
Version:     V1.0.1   -- 2024-06-11
******************************************************************/
#include "BMduino_WS2812.h"


/**********************************************************
Description: Constructor
Parameters:  LEDlength:number of RGB
             dataPin:digital pin
Return: none
Others: none
**********************************************************/
BMduino_WS2812::BMduino_WS2812(uint8_t LEDlength,uint8_t dataPin)
{
  LEDBuffer=new uint8_t[LEDlength*3];
  _dataPin=dataPin;
  _LEDlength=LEDlength;
  status=false;
}

/**********************************************************
Description: release function
Parameters: none
Return:  none
Others:  none
**********************************************************/
BMduino_WS2812::~BMduino_WS2812() {
  if(LEDBuffer!=NULL)
    delete []LEDBuffer;
  pinMode(_dataPin, INPUT);
}
/**********************************************************
Description: initial port and data
Parameters:none
Return:void
Others:none
**********************************************************/
void BMduino_WS2812::begin()
{
  if (isNotDigitalPin(_dataPin))
  {
    status=false;
    return;
  }
  if(LEDBuffer==NULL)
  {
    status=false;
    return;
  }
  pinMode(_dataPin, OUTPUT);
  digitalWrite(_dataPin, LOW);
  status=true;
}
/**********************************************************
Description: define new RGB number
Parameters:  LEDlength : number of RGB ，min：0，max：255
Return:void
Others:none
**********************************************************/
void BMduino_WS2812::updateLength(uint8_t LEDlength)
{
  if(LEDlength==0)
  {status=false;return;}
  else
  {
     if(LEDBuffer!=NULL)delete []LEDBuffer;
     LEDBuffer=new uint8_t[LEDlength*3];
     if(LEDBuffer==NULL) 
     {status=false;return;}
     else
     {
      for(uint16_t i=0;i<LEDlength*3;i+=3)
      {
        status=true;
        LEDBuffer[i]=0;
        LEDBuffer[i+1]=0;
        LEDBuffer[i+2]=0;
      }
      _LEDlength= LEDlength;

     }
  }
}

/**********************************************************
Description: fill RGB data buffer 
Parameters:  first : the frist RGB，min：0，max：255
             n : number of RGB，min：0，max：255
             r/g/b:color data，min：0，max：255
Return:void
Others:none
**********************************************************/
void BMduino_WS2812::fill(uint8_t first,uint8_t n, uint8_t r, uint8_t g, uint8_t b)
{
    uint8_t end;
   if (status==false)
  {
    return;
  } 
   if(first>=_LEDlength)return;
    end= first+n;
   if(end>_LEDlength)end=_LEDlength; 
  for (uint8_t i = first*3; i < end*3; i+=3)
  {
    LEDBuffer[i]=g;
    LEDBuffer[i+1]=r;
    LEDBuffer[i+2]=b;
  }
  
}
/**********************************************************
Description: refresh LED
Parameters: none
Return:void
Others:none
**********************************************************/
void BMduino_WS2812::show()
{
  if (status==false)
  {   
    return;
  }
    HT_GPIO_TypeDef *HT_GPIOx = digitalPinToPort(_dataPin);
    uint32_t GPIO_PIN =  digitalPinToBitMask(_dataPin);

  vu32 i, j ;
  vu32 bit;
  vu32 Shift=0;
  noInterrupts();
 
  //HT_GPIOx->RR = GPIO_PIN;
  for (j = 0; j <_LEDlength * 3 ; j++)
  {
    bit = LEDBuffer[j];//*ptr++;
    for (i = 8; i != 0; i--)
    {
      HT_GPIOx->SRR = GPIO_PIN;
      
      Shift = !(bit & 0x80);

      {
        asm("nop; nop; nop; nop;nop; nop;nop;");
      }

      if(Shift)
        HT_GPIOx->RR = GPIO_PIN;

      {
        asm("nop; nop; nop; nop;nop;nop;nop; nop;  nop; nop; nop; nop;nop;nop; nop; nop; nop;   ");
      }


      HT_GPIOx->RR = GPIO_PIN;

      bit = bit << 1;
      {
          asm("nop; nop; nop; nop; nop;nop;nop;");
      }
    }
  }
  interrupts();
  {
    vu32 _index;
    for(_index = 0;_index < 2000;_index++)
    {
      __NOP();
    }
  }
}




















