/*****************************************************************
File:         colorful.ino
Description:  Demonstration of WS2812 Colorful Gradient with 50 LEDs.
******************************************************************/
#include <BMduino_WS2812.h>
BMduino_WS2812 BW;

typedef struct RGB_DATA
{
  uint8_t r;
  uint8_t g;
  uint8_t b;
}rgb_def;

uint8_t LEDnumber=50;//number of rgb
int flow_step=0; //step of color action
#define SET_BRIGHTNESS 50  //brightness:1~255

rgb_def get_color(int level);

void setup() {

  BW.begin();
  BW.updateLength(LEDnumber);//Set the number of RGBs on my light strip
}

void loop() {
    rgb_def rgb;

    for (uint8_t i = 0; i < LEDnumber; i++)//update LEDnumber RGB
    {
        rgb = get_color(flow_step+i*5);//get color to update RGB,i*5 is color band
        rgb.r = rgb.r*SET_BRIGHTNESS/255;
        rgb.g = rgb.g*SET_BRIGHTNESS/255;
        rgb.b = rgb.b*SET_BRIGHTNESS/255;
        BW.fill(i,1,rgb.r,rgb.g,rgb.b);//fill 1 RGB from position i
    }
    BW.show();  //refresh display
    if((flow_step++) > 420) {flow_step = 0;}//flowing ,420 color level
     delay(20);
}

rgb_def get_color(int level)//Change color through calculation
{
  rgb_def rgb;
  
  if(level<0){level+=420;}
  if(level>419){level-=420;}

  if(level<60)  //step 1:red->yellow
  {
    rgb.r=240;
    rgb.g=4 * level;
    rgb.b=0;
  }
  else if(level<120)//step 2:yellow->green
  {
    rgb.r=240-(4*(level-60));
    rgb.g=240;
    rgb.b=0;
  }
  else if(level<180)//step 3:green->cyan
  {
    rgb.r=0;
    rgb.g=240;
    rgb.b=4*(level-120);
  }
  else if(level<240)//step 4:cyan close to blue
  {
    rgb.r=0;
    rgb.g=240-(3*(level-180));
    rgb.b=240;
  }
  else if(level<300)//step 5:blue->purple
  {
    rgb.r=(level-240);
    rgb.g=60-(level-240);
    rgb.b=240-(2*(level-240));
  }
  else if(level<360)//step6:purple->pink
  {
    rgb.r=60+(level-300);
    rgb.g=0;
    rgb.b=120;
  }
  else if(level<420)//step7:pink->red
  {
    rgb.r=120+(2*(level-360));
    rgb.g=0;
    rgb.b=120-(2*(level-360));
  }

  return rgb;   
}
