/*****************************************************************
File:         colorflow.ino
Description:  Demonstration of WS2812 Color Flowing with 50 LEDs.
******************************************************************/
#include <BMduino_WS2812.h>
BMduino_WS2812 BW;

typedef struct RGB_DATA
{
  uint8_t r;
  uint8_t g;
  uint8_t b;
}rgb_def;
rgb_def colorTable[6]=
{
  {70,0,0}, 
  {0,60,0}, 
  {0,0,80}, 
  {50,50,0}, 
  {50,0,50}, 
  {0,50,50},
};
uint8_t LEDnumber=50;//number of rgb
int flow_step=0; //step of color action



void setup() {

  BW.begin();
  BW.updateLength(LEDnumber);//Set the number of RGBs on my light strip
}



void loop()
{  
  for (uint8_t j = 0; j < 6; j++)
  {
    for (uint8_t i = 0; i < LEDnumber; i++)//update LEDnumber RGB
    {
        BW.fill(i,1,colorTable[j].r,colorTable[j].g,colorTable[j].b);//fill 1 RGB from position i
        delay(10);
        BW.show();  //refresh display
    } 
    //delay(1000); 
  }
}
